/*
 * Decompiled with CFR 0.152.
 */
package com.voxelutopia.ultramarine.datagen;

import com.google.common.collect.ImmutableSet;
import com.voxelutopia.ultramarine.Ultramarine;
import com.voxelutopia.ultramarine.data.registry.BlockRegistry;
import com.voxelutopia.ultramarine.data.registry.ItemRegistry;
import com.voxelutopia.ultramarine.world.block.BaseBlockProperty;
import com.voxelutopia.ultramarine.world.block.BaseBlockPropertyHolder;
import com.voxelutopia.ultramarine.world.block.ConsumableDecorativeBlock;
import com.voxelutopia.ultramarine.world.block.StackableHalfBlock;
import com.voxelutopia.ultramarine.world.block.state.ModBlockStateProperties;
import com.voxelutopia.ultramarine.world.block.state.StackableBlockType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import net.minecraft.advancements.critereon.EnchantmentPredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DropExperienceBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.ApplyBonusCount;
import net.minecraft.world.level.storage.loot.functions.ApplyExplosionDecay;
import net.minecraft.world.level.storage.loot.functions.FunctionUserBuilder;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceCondition;
import net.minecraft.world.level.storage.loot.predicates.MatchTool;
import net.minecraft.world.level.storage.loot.providers.number.BinomialDistributionGenerator;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import net.minecraftforge.registries.RegistryObject;
import org.slf4j.Logger;

public class ModBlockLootProvider
extends BlockLootSubProvider {
    private static final List<RegistryObject<Block>> NON_SIMPLE_BLOCKS = new ArrayList<RegistryObject<Block>>();
    private static final List<Class<? extends Block>> NON_SIMPLE_BLOCK_CLASSES = List.of(DropExperienceBlock.class, SlabBlock.class, ConsumableDecorativeBlock.class, StackableHalfBlock.class);
    private static final Logger LOGGER = Ultramarine.getLogger();
    private static final LootItemCondition.Builder HAS_SILK_TOUCH = MatchTool.m_81997_((ItemPredicate.Builder)ItemPredicate.Builder.m_45068_().m_45071_(new EnchantmentPredicate(Enchantments.f_44985_, MinMaxBounds.Ints.m_55386_((int)1))));
    private static final Set<Item> EXPLOSION_RESISTANT = (Set)Stream.of(Blocks.f_50752_).map(ItemLike::m_5456_).collect(ImmutableSet.toImmutableSet());
    protected final Map<Block, LootTable.Builder> lootTables = new HashMap<Block, LootTable.Builder>();

    public ModBlockLootProvider() {
        super(Set.of(), FeatureFlags.f_244280_.m_247355_());
    }

    protected void m_245660_() {
        BlockRegistry.BLOCKS.getEntries().stream().filter(blockRegistryObject -> !NON_SIMPLE_BLOCKS.contains(blockRegistryObject)).forEach(this::simple);
        this.ore(BlockRegistry.JADE_ORE, ItemRegistry.JADE);
        this.ore(BlockRegistry.DEEPSLATE_JADE_ORE, ItemRegistry.JADE);
        this.ore(BlockRegistry.HEMATITE_ORE, ItemRegistry.RAW_HEMATITE);
        this.ore(BlockRegistry.DEEPSLATE_HEMATITE_ORE, ItemRegistry.RAW_HEMATITE);
        this.abundantOre(BlockRegistry.MAGNESITE_ORE, ItemRegistry.MAGNESITE);
        this.abundantOre(BlockRegistry.DEEPSLATE_MAGNESITE_ORE, ItemRegistry.MAGNESITE);
        this.ore(BlockRegistry.NETHER_COBALT_ORE, ItemRegistry.RAW_COBALT);
        this.porcelain(BlockRegistry.BLUE_AND_WHITE_PORCELAIN_FLOWERPOT, ItemRegistry.BLUE_AND_WHITE_PORCELAIN_PIECE, ItemRegistry.BLUE_AND_WHITE_PORCELAIN_SHARDS);
        this.porcelain(BlockRegistry.BLUE_AND_WHITE_PORCELAIN_VASE, ItemRegistry.BLUE_AND_WHITE_PORCELAIN_PIECE, ItemRegistry.BLUE_AND_WHITE_PORCELAIN_SHARDS);
        this.porcelain(BlockRegistry.LARGE_BLUE_AND_WHITE_PORCELAIN_VASE, ItemRegistry.BLUE_AND_WHITE_PORCELAIN_PIECE, ItemRegistry.BLUE_AND_WHITE_PORCELAIN_SHARDS);
        this.porcelain(BlockRegistry.SHORT_BLUE_AND_WHITE_PORCELAIN_POT, ItemRegistry.BLUE_AND_WHITE_PORCELAIN_PIECE, ItemRegistry.BLUE_AND_WHITE_PORCELAIN_SHARDS);
        this.porcelain(BlockRegistry.TALL_BLUE_AND_WHITE_PORCELAIN_POT, ItemRegistry.BLUE_AND_WHITE_PORCELAIN_PIECE, ItemRegistry.BLUE_AND_WHITE_PORCELAIN_SHARDS);
        this.porcelain(BlockRegistry.BLUE_AND_WHITE_PORCELAIN_BOWL, ItemRegistry.BLUE_AND_WHITE_PORCELAIN_PIECE, ItemRegistry.BLUE_AND_WHITE_PORCELAIN_SHARDS);
        this.porcelain(BlockRegistry.WINE_POT, ItemRegistry.BLUE_AND_WHITE_PORCELAIN_PIECE, ItemRegistry.BLUE_AND_WHITE_PORCELAIN_SHARDS);
        this.porcelainPlate(BlockRegistry.PLATED_MOONCAKES, ItemRegistry.BLUE_AND_WHITE_PORCELAIN_PIECE, ItemRegistry.BLUE_AND_WHITE_PORCELAIN_SHARDS);
        this.plateDrop(BlockRegistry.PLATED_MUNG_BEAN_CAKES);
        this.plateDrop(BlockRegistry.PLATED_HAM);
        this.plateDrop(BlockRegistry.PLATED_FISH);
        this.slab(BlockRegistry.CYAN_BRICK_SLAB, ItemRegistry.CYAN_BRICK_SLAB);
        this.slab(BlockRegistry.BLACK_BRICK_SLAB, ItemRegistry.BLACK_BRICK_SLAB);
        this.slab(BlockRegistry.BROWNISH_RED_STONE_BRICK_SLAB, ItemRegistry.BROWNISH_RED_STONE_BRICK_SLAB);
        this.slab(BlockRegistry.PALE_YELLOW_STONE_SLAB, ItemRegistry.PALE_YELLOW_STONE_SLAB);
        this.slab(BlockRegistry.VARIEGATED_ROCK_SLAB, ItemRegistry.VARIEGATED_ROCK_SLAB);
        this.slab(BlockRegistry.WEATHERED_STONE_SLAB, ItemRegistry.WEATHERED_STONE_SLAB);
        this.slab(BlockRegistry.POLISHED_WEATHERED_STONE_SLAB, ItemRegistry.POLISHED_WEATHERED_STONE_SLAB);
        this.slab(BlockRegistry.LIGHT_CYAN_FLOOR_TILE_SLAB, ItemRegistry.LIGHT_CYAN_FLOOR_TILE_SLAB);
        this.slab(BlockRegistry.CYAN_FLOOR_TILE_SLAB, ItemRegistry.CYAN_FLOOR_TILE_SLAB);
        this.slab(BlockRegistry.BAMBOO_MAT_SLAB, ItemRegistry.BAMBOO_MAT_SLAB);
        this.stackableHalf(BlockRegistry.CABBAGE_BASKET, ItemRegistry.CABBAGE_BASKET);
    }

    void simple(RegistryObject<? extends Block> block) {
        this.addLootTable((Block)block.get(), this.createSimpleTable(block.getId().m_135815_(), (ItemLike)block.get()));
    }

    void ore(RegistryObject<? extends Block> block, RegistryObject<? extends Item> item) {
        this.addLootTable((Block)block.get(), ModBlockLootProvider.createOreDrop(block.getId().m_135815_(), (Block)block.get(), (Item)item.get()));
    }

    void abundantOre(RegistryObject<? extends Block> block, RegistryObject<? extends Item> item) {
        this.addLootTable((Block)block.get(), ModBlockLootProvider.createAbundantOreDrop(block.getId().m_135815_(), (Block)block.get(), (Item)item.get(), 1.0f, 3.0f));
    }

    void porcelain(RegistryObject<? extends Block> block, RegistryObject<? extends Item> piece, RegistryObject<? extends Item> shards) {
        this.addLootTable((Block)block.get(), ModBlockLootProvider.createPorcelainDrop(block.getId().m_135815_(), (Block)block.get(), (Item)piece.get(), (Item)shards.get()));
    }

    void porcelainPlate(RegistryObject<? extends Block> block, RegistryObject<? extends Item> piece, RegistryObject<? extends Item> shards) {
        ConsumableDecorativeBlock consumable;
        Object object = block.get();
        if (object instanceof ConsumableDecorativeBlock && (object = (consumable = (ConsumableDecorativeBlock)object).getPlate().m_41720_()) instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)object;
            this.addLootTable((Block)block.get(), ModBlockLootProvider.createPorcelainDrop(block.getId().m_135815_(), blockItem.m_40614_(), (Item)piece.get(), (Item)shards.get()));
        } else {
            LOGGER.warn("Porcelain plate loot table was not added for block " + ((Block)block.get()).m_7705_());
        }
    }

    void slab(RegistryObject<? extends Block> block, RegistryObject<? extends Item> item) {
        Object object = block.get();
        if (object instanceof SlabBlock) {
            SlabBlock slab = (SlabBlock)object;
            this.addLootTable((Block)block.get(), this.createSlabDrop(block.getId().m_135815_(), slab, (Item)item.get()));
        } else {
            LOGGER.warn("Slab loot table was not added for block " + ((Block)block.get()).m_7705_());
        }
    }

    void stackableHalf(RegistryObject<? extends Block> block, RegistryObject<? extends Item> item) {
        Object object = block.get();
        if (object instanceof StackableHalfBlock) {
            StackableHalfBlock stackable = (StackableHalfBlock)object;
            this.addLootTable((Block)block.get(), this.createStackableHalfDrop(block.getId().m_135815_(), stackable, (Item)item.get()));
        } else {
            LOGGER.warn("Stackable loot table was not added for block " + ((Block)block.get()).m_7705_());
        }
    }

    void plateDrop(RegistryObject<? extends Block> block) {
        Object object = block.get();
        if (object instanceof ConsumableDecorativeBlock) {
            ConsumableDecorativeBlock consumable = (ConsumableDecorativeBlock)object;
            this.addLootTable((Block)block.get(), this.createSimpleTable(block.getId().m_135815_(), (ItemLike)consumable.getPlate().m_41720_()));
        } else {
            LOGGER.warn("Plate drop loot table was not added for block " + ((Block)block.get()).m_7705_());
        }
    }

    void addLootTable(Block block, LootTable.Builder builder) {
        if (this.lootTables.containsKey(block)) {
            LOGGER.warn("Added duplicate loot table for block " + block.m_7705_());
        }
        this.lootTables.put(block, builder);
    }

    protected LootTable.Builder createSimpleTable(String name, ItemLike block) {
        LootPool.Builder builder = LootPool.m_79043_().name(name).m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)block));
        return LootTable.m_79147_().m_79161_(builder);
    }

    protected LootTable.Builder createSingleItemTable(String name, Block block, Item drops) {
        LootPool.Builder builder = LootPool.m_79043_().name(name).m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)drops));
        return LootTable.m_79147_().m_79161_(builder);
    }

    protected LootTable.Builder createSlabDrop(String name, SlabBlock block, Item item) {
        LootPool.Builder builder = LootPool.m_79043_().name(name).m_79076_(LootItem.m_79579_((ItemLike)item).m_79080_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)block).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67697_((Property)SlabBlock.f_56353_, (Comparable)SlabType.TOP)))).m_79076_(LootItem.m_79579_((ItemLike)item).m_79080_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)block).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67697_((Property)SlabBlock.f_56353_, (Comparable)SlabType.BOTTOM)))).m_79076_((LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)LootItem.m_79579_((ItemLike)item).m_79080_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)block).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67697_((Property)SlabBlock.f_56353_, (Comparable)SlabType.DOUBLE)))).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)2.0f))));
        return LootTable.m_79147_().m_79161_(builder);
    }

    protected LootTable.Builder createStackableHalfDrop(String name, StackableHalfBlock block, Item item) {
        LootPool.Builder builder = LootPool.m_79043_().name(name).m_79076_(LootItem.m_79579_((ItemLike)item).m_79080_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)block).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67697_(ModBlockStateProperties.STACKABLE_BLOCK_TYPE, (Comparable)((Object)StackableBlockType.SINGLE))))).m_79076_((LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)LootItem.m_79579_((ItemLike)item).m_79080_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)block).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67697_(ModBlockStateProperties.STACKABLE_BLOCK_TYPE, (Comparable)((Object)StackableBlockType.DOUBLE))))).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)2.0f))));
        return LootTable.m_79147_().m_79161_(builder);
    }

    protected static LootTable.Builder createAbundantOreDrop(String name, Block block, Item drop, float min, float max) {
        return ModBlockLootProvider.createSilkTouchDispatchTable(block, name, (LootPoolEntryContainer.Builder)ModBlockLootProvider.explosionDecay((ItemLike)block, LootItem.m_79579_((ItemLike)drop).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)min, (float)max))).m_79078_((LootItemFunction.Builder)ApplyBonusCount.m_79915_((Enchantment)Enchantments.f_44987_))));
    }

    protected static LootTable.Builder createOreDrop(String name, Block block, Item drop) {
        return ModBlockLootProvider.createSilkTouchDispatchTable(block, name, (LootPoolEntryContainer.Builder)ModBlockLootProvider.explosionDecay((ItemLike)block, LootItem.m_79579_((ItemLike)drop).m_79078_((LootItemFunction.Builder)ApplyBonusCount.m_79915_((Enchantment)Enchantments.f_44987_))));
    }

    protected static LootTable.Builder createPorcelainDrop(String name, Block block, Item piece, Item shard) {
        return LootTable.m_79147_().m_79161_(LootPool.m_79043_().name(name).m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)LootItem.m_79579_((ItemLike)block).m_79080_(HAS_SILK_TOUCH)).m_7170_((LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)LootItem.m_79579_((ItemLike)piece).m_79080_(LootItemRandomChanceCondition.m_81927_((float)0.01f))).m_79078_((LootItemFunction.Builder)ApplyBonusCount.m_79921_((Enchantment)Enchantments.f_44987_, (int)2))).m_7170_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)shard).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)BinomialDistributionGenerator.m_165659_((int)3, (float)0.5f))))));
    }

    protected static LootTable.Builder createSelfDropDispatchTable(Block pBlock, String name, LootItemCondition.Builder pConditionBuilder, LootPoolEntryContainer.Builder<?> pAlternativeEntryBuilder) {
        return LootTable.m_79147_().m_79161_(LootPool.m_79043_().name(name).m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)LootItem.m_79579_((ItemLike)pBlock).m_79080_(pConditionBuilder)).m_7170_(pAlternativeEntryBuilder)));
    }

    protected static LootTable.Builder createSilkTouchDispatchTable(Block pBlock, String name, LootPoolEntryContainer.Builder<?> pAlternativeEntryBuilder) {
        return ModBlockLootProvider.createSelfDropDispatchTable(pBlock, name, HAS_SILK_TOUCH, pAlternativeEntryBuilder);
    }

    protected static <T extends FunctionUserBuilder<T>> T explosionDecay(ItemLike pItem, FunctionUserBuilder<T> pFunction) {
        return (T)(!EXPLOSION_RESISTANT.contains(pItem.m_5456_()) ? pFunction.m_79078_((LootItemFunction.Builder)ApplyExplosionDecay.m_80037_()) : pFunction.m_79073_());
    }

    protected Iterable<Block> getKnownBlocks() {
        return BlockRegistry.BLOCKS.getEntries().stream().map(RegistryObject::get)::iterator;
    }

    static {
        BlockRegistry.BLOCKS.getEntries().stream().filter(blockRegistryObject -> {
            Block block = (Block)blockRegistryObject.get();
            for (Class<? extends Block> clazz : NON_SIMPLE_BLOCK_CLASSES) {
                if (!clazz.isInstance(block)) continue;
                return true;
            }
            if (block instanceof BaseBlockPropertyHolder) {
                BaseBlockPropertyHolder baseBlock = (BaseBlockPropertyHolder)block;
                return baseBlock.getProperty().getMaterial() == BaseBlockProperty.BlockMaterial.PORCELAIN;
            }
            return false;
        }).forEach(NON_SIMPLE_BLOCKS::add);
    }
}

